/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateMatrixFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.FiniteDifferencesDifferentiator$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.FiniteDifferencesDifferentiator$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.FiniteDifferencesDifferentiator$3;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableMatrixFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateFunctionDifferentiator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateMatrixFunctionDifferentiator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateVectorFunctionDifferentiator;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooSmallException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import java.io.Serializable;

public class FiniteDifferencesDifferentiator
implements UnivariateFunctionDifferentiator,
UnivariateMatrixFunctionDifferentiator,
UnivariateVectorFunctionDifferentiator,
Serializable {
    private static final long serialVersionUID = 20120917L;
    private final int nbPoints;
    private final double stepSize;
    private final double halfSampleSpan;
    private final double tMin;
    private final double tMax;

    public FiniteDifferencesDifferentiator(int n, double d2) {
        this(n, d2, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public FiniteDifferencesDifferentiator(int n, double d2, double d3, double d4) {
        if (n <= 1) {
            throw new NumberIsTooSmallException(d2, (Number)1, false);
        }
        this.nbPoints = n;
        if (d2 <= 0.0) {
            throw new NotPositiveException(d2);
        }
        this.stepSize = d2;
        this.halfSampleSpan = d2 * 0.5 * (double)(n - 1);
        if (2.0 * this.halfSampleSpan >= d4 - d3) {
            throw new NumberIsTooLargeException(2.0 * this.halfSampleSpan, (Number)(d4 - d3), false);
        }
        double d5 = FastMath.ulp(this.halfSampleSpan);
        this.tMin = d3 + this.halfSampleSpan + d5;
        this.tMax = d4 - this.halfSampleSpan - d5;
    }

    public int getNbPoints() {
        return this.nbPoints;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    private DerivativeStructure evaluate(DerivativeStructure derivativeStructure, double d2, double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = new double[this.nbPoints];
        Object object = new double[this.nbPoints];
        for (n2 = 0; n2 < this.nbPoints; ++n2) {
            object[n2] = dArray[n2];
            for (n = 1; n <= n2; ++n) {
                object[n2 - n] = (object[n2 - n + 1] - object[n2 - n]) / ((double)n * this.stepSize);
            }
            dArray2[n2] = object[0];
        }
        n2 = derivativeStructure.getOrder();
        n = derivativeStructure.getFreeParameters();
        dArray = derivativeStructure.getAllDerivatives();
        double d3 = derivativeStructure.getValue() - d2;
        derivativeStructure = new DerivativeStructure(n, n2, 0.0);
        DerivativeStructure derivativeStructure2 = null;
        for (int i2 = 0; i2 < this.nbPoints; ++i2) {
            if (i2 == 0) {
                derivativeStructure2 = new DerivativeStructure(n, n2, 1.0);
            } else {
                dArray[0] = d3 - (double)(i2 - 1) * this.stepSize;
                object = new DerivativeStructure(n, n2, dArray);
                derivativeStructure2 = derivativeStructure2.multiply((DerivativeStructure)object);
            }
            derivativeStructure = derivativeStructure.add(derivativeStructure2.multiply(dArray2[i2]));
        }
        return derivativeStructure;
    }

    public UnivariateDifferentiableFunction differentiate(UnivariateFunction univariateFunction) {
        return new FiniteDifferencesDifferentiator$1(this, univariateFunction);
    }

    public UnivariateDifferentiableVectorFunction differentiate(UnivariateVectorFunction univariateVectorFunction) {
        return new FiniteDifferencesDifferentiator$2(this, univariateVectorFunction);
    }

    public UnivariateDifferentiableMatrixFunction differentiate(UnivariateMatrixFunction univariateMatrixFunction) {
        return new FiniteDifferencesDifferentiator$3(this, univariateMatrixFunction);
    }

    static /* synthetic */ int access$000(FiniteDifferencesDifferentiator finiteDifferencesDifferentiator) {
        return finiteDifferencesDifferentiator.nbPoints;
    }

    static /* synthetic */ double access$100(FiniteDifferencesDifferentiator finiteDifferencesDifferentiator) {
        return finiteDifferencesDifferentiator.tMax;
    }

    static /* synthetic */ double access$200(FiniteDifferencesDifferentiator finiteDifferencesDifferentiator) {
        return finiteDifferencesDifferentiator.tMin;
    }

    static /* synthetic */ double access$300(FiniteDifferencesDifferentiator finiteDifferencesDifferentiator) {
        return finiteDifferencesDifferentiator.halfSampleSpan;
    }

    static /* synthetic */ double access$400(FiniteDifferencesDifferentiator finiteDifferencesDifferentiator) {
        return finiteDifferencesDifferentiator.stepSize;
    }

    static /* synthetic */ DerivativeStructure access$500(FiniteDifferencesDifferentiator finiteDifferencesDifferentiator, DerivativeStructure derivativeStructure, double d2, double[] dArray) {
        return finiteDifferencesDifferentiator.evaluate(derivativeStructure, d2, dArray);
    }
}

