/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.DimensionMismatchException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.MathInternalError;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.CombinatoricsUtils;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.FastMath;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.util.MathArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public class DSCompiler {
    private static AtomicReference<DSCompiler[][]> compilers = new AtomicReference<Object>(null);
    private final int parameters;
    private final int order;
    private final int[][] sizes;
    private final int[][] derivativesIndirection;
    private final int[] lowerIndirection;
    private final int[][][] multIndirection;
    private final int[][][] compIndirection;

    private DSCompiler(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2) {
        this.parameters = n;
        this.order = n2;
        this.sizes = DSCompiler.compileSizes(n, n2, dSCompiler);
        this.derivativesIndirection = DSCompiler.compileDerivativesIndirection(n, n2, dSCompiler, dSCompiler2);
        this.lowerIndirection = DSCompiler.compileLowerIndirection(n, n2, dSCompiler, dSCompiler2);
        this.multIndirection = DSCompiler.compileMultiplicationIndirection(n, n2, dSCompiler, dSCompiler2, this.lowerIndirection);
        this.compIndirection = DSCompiler.compileCompositionIndirection(n, n2, dSCompiler, dSCompiler2, this.sizes, this.derivativesIndirection);
    }

    public static DSCompiler getCompiler(int n, int n2) {
        DSCompiler[][] dSCompilerArray = compilers.get();
        if (dSCompilerArray != null && dSCompilerArray.length > n && dSCompilerArray[n].length > n2 && dSCompilerArray[n][n2] != null) {
            return dSCompilerArray[n][n2];
        }
        int n3 = FastMath.max(n, dSCompilerArray == null ? 0 : dSCompilerArray.length);
        int n4 = FastMath.max(n2, dSCompilerArray == null ? 0 : dSCompilerArray[0].length);
        DSCompiler[][] dSCompilerArray2 = new DSCompiler[n3 + 1][n4 + 1];
        if (dSCompilerArray != null) {
            for (n4 = 0; n4 < dSCompilerArray.length; ++n4) {
                System.arraycopy(dSCompilerArray[n4], 0, dSCompilerArray2[n4], 0, dSCompilerArray[n4].length);
            }
        }
        for (n4 = 0; n4 <= n + n2; ++n4) {
            for (int i2 = FastMath.max(0, n4 - n); i2 <= FastMath.min(n2, n4); ++i2) {
                int n5 = n4 - i2;
                if (dSCompilerArray2[n5][i2] != null) continue;
                DSCompiler dSCompiler = n5 == 0 ? null : dSCompilerArray2[n5 - 1][i2];
                DSCompiler dSCompiler2 = i2 == 0 ? null : dSCompilerArray2[n5][i2 - 1];
                dSCompilerArray2[n5][i2] = new DSCompiler(n5, i2, dSCompiler, dSCompiler2);
            }
        }
        compilers.compareAndSet(dSCompilerArray, dSCompilerArray2);
        return dSCompilerArray2[n][n2];
    }

    private static int[][] compileSizes(int n, int n2, DSCompiler dSCompiler) {
        int[][] nArray = new int[n + 1][n2 + 1];
        if (n == 0) {
            Arrays.fill(nArray[0], 1);
        } else {
            System.arraycopy(dSCompiler.sizes, 0, nArray, 0, n);
            nArray[n][0] = 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[n][i2 + 1] = nArray[n][i2] + nArray[n - 1][i2 + 1];
            }
        }
        return nArray;
    }

    private static int[][] compileDerivativesIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2) {
        int n3;
        if (n == 0 || n2 == 0) {
            return new int[1][n];
        }
        n2 = dSCompiler.derivativesIndirection.length;
        int n4 = dSCompiler2.derivativesIndirection.length;
        int[][] nArray = new int[n2 + n4][n];
        for (n3 = 0; n3 < n2; ++n3) {
            System.arraycopy(dSCompiler.derivativesIndirection[n3], 0, nArray[n3], 0, n - 1);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            System.arraycopy(dSCompiler2.derivativesIndirection[n3], 0, nArray[n2 + n3], 0, n);
            int[] nArray2 = nArray[n2 + n3];
            int n5 = n - 1;
            nArray2[n5] = nArray2[n5] + 1;
        }
        return nArray;
    }

    private static int[] compileLowerIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2) {
        if (n == 0 || n2 <= 1) {
            return new int[]{0};
        }
        n = dSCompiler.lowerIndirection.length;
        n2 = dSCompiler2.lowerIndirection.length;
        int[] nArray = new int[n + n2];
        System.arraycopy(dSCompiler.lowerIndirection, 0, nArray, 0, n);
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[n + i2] = dSCompiler.getSize() + dSCompiler2.lowerIndirection[i2];
        }
        return nArray;
    }

    private static int[][][] compileMultiplicationIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2, int[] nArray) {
        if (n == 0 || n2 == 0) {
            return new int[][][]{new int[][]{{1, 0, 0}}};
        }
        n = dSCompiler.multIndirection.length;
        n2 = dSCompiler2.multIndirection.length;
        int[][][] nArrayArray = new int[n + n2][][];
        System.arraycopy(dSCompiler.multIndirection, 0, nArrayArray, 0, n);
        for (int i2 = 0; i2 < n2; ++i2) {
            int[][] nArray2 = dSCompiler2.multIndirection[i2];
            ArrayList<int[]> arrayList = new ArrayList<int[]>(nArray2.length << 1);
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                arrayList.add(new int[]{nArray2[i3][0], nArray[nArray2[i3][1]], n + nArray2[i3][2]});
                arrayList.add(new int[]{nArray2[i3][0], n + nArray2[i3][1], nArray[nArray2[i3][2]]});
            }
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>(arrayList.size());
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                int[] nArray3 = (int[])arrayList.get(i4);
                if (nArray3[0] <= 0) continue;
                for (int i5 = i4 + 1; i5 < arrayList.size(); ++i5) {
                    int[] nArray4 = (int[])arrayList.get(i5);
                    if (nArray3[1] != nArray4[1] || nArray3[2] != nArray4[2]) continue;
                    nArray3[0] = nArray3[0] + nArray4[0];
                    nArray4[0] = 0;
                }
                arrayList2.add(nArray3);
            }
            ArrayList<int[]> arrayList3 = arrayList2;
            nArrayArray[n + i2] = (int[][])arrayList3.toArray((T[])new int[arrayList3.size()][]);
        }
        return nArrayArray;
    }

    private static int[][][] compileCompositionIndirection(int n, int n2, DSCompiler dSCompiler, DSCompiler dSCompiler2, int[][] nArray, int[][] nArray2) {
        if (n == 0 || n2 == 0) {
            return new int[][][]{new int[][]{{1, 0}}};
        }
        int n3 = dSCompiler.compIndirection.length;
        int n4 = dSCompiler2.compIndirection.length;
        int[][][] nArrayArray = new int[n3 + n4][][];
        System.arraycopy(dSCompiler.compIndirection, 0, nArrayArray, 0, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int[] nArray3;
            ArrayList<int[]> arrayList = new ArrayList<int[]>();
            for (int[] nArray4 : dSCompiler2.compIndirection[i2]) {
                int[] nArray5 = new int[nArray4.length + 1];
                nArray3 = nArray5;
                nArray5[0] = nArray4[0];
                nArray3[1] = nArray4[1] + 1;
                int[] nArray6 = new int[n];
                int[] nArray7 = nArray6;
                nArray6[n - 1] = 1;
                nArray3[nArray4.length] = DSCompiler.getPartialDerivativeIndex(n, n2, nArray, nArray7);
                for (n5 = 2; n5 < nArray4.length; ++n5) {
                    nArray3[n5] = DSCompiler.convertIndex(nArray4[n5], n, dSCompiler2.derivativesIndirection, n, n2, nArray);
                }
                Arrays.sort(nArray3, 2, nArray3.length);
                arrayList.add(nArray3);
                for (n5 = 2; n5 < nArray4.length; ++n5) {
                    int[] nArray8 = new int[nArray4.length];
                    nArray3 = nArray8;
                    nArray8[0] = nArray4[0];
                    nArray3[1] = nArray4[1];
                    for (int i3 = 2; i3 < nArray4.length; ++i3) {
                        nArray3[i3] = DSCompiler.convertIndex(nArray4[i3], n, dSCompiler2.derivativesIndirection, n, n2, nArray);
                        if (i3 != n5) continue;
                        System.arraycopy(nArray2[nArray3[i3]], 0, nArray7, 0, n);
                        int n6 = n - 1;
                        nArray7[n6] = nArray7[n6] + 1;
                        nArray3[i3] = DSCompiler.getPartialDerivativeIndex(n, n2, nArray, nArray7);
                    }
                    Arrays.sort(nArray3, 2, nArray3.length);
                    arrayList.add(nArray3);
                }
            }
            Object object = new ArrayList(arrayList.size());
            for (int i4 = 0; i4 < arrayList.size(); ++i4) {
                int[] nArray9 = (int[])arrayList.get(i4);
                if (nArray9[0] <= 0) continue;
                for (int i5 = i4 + 1; i5 < arrayList.size(); ++i5) {
                    nArray3 = (int[])arrayList.get(i5);
                    boolean bl = nArray9.length == nArray3.length;
                    for (n5 = 1; bl && n5 < nArray9.length; bl &= nArray9[n5] == nArray3[n5], ++n5) {
                    }
                    if (!bl) continue;
                    nArray9[0] = nArray9[0] + nArray3[0];
                    nArray3[0] = 0;
                }
                object.add(nArray9);
            }
            Object object2 = object;
            nArrayArray[n3 + i2] = (int[][])object2.toArray((T[])new int[object2.size()][]);
        }
        return nArrayArray;
    }

    public int getPartialDerivativeIndex(int ... nArray) {
        if (nArray.length != this.getFreeParameters()) {
            throw new DimensionMismatchException(nArray.length, this.getFreeParameters());
        }
        return DSCompiler.getPartialDerivativeIndex(this.parameters, this.order, this.sizes, nArray);
    }

    private static int getPartialDerivativeIndex(int n, int n2, int[][] nArray, int ... nArray2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        --n;
        while (n >= 0) {
            int n6 = nArray2[n];
            if ((n5 += n6) > n2) {
                throw new NumberIsTooLargeException(n5, (Number)n2, true);
            }
            while (n6-- > 0) {
                n3 += nArray[n][n4--];
            }
            --n;
        }
        return n3;
    }

    private static int convertIndex(int n, int n2, int[][] nArray, int n3, int n4, int[][] nArray2) {
        int[] nArray3 = new int[n3];
        System.arraycopy(nArray[n], 0, nArray3, 0, FastMath.min(n2, n3));
        return DSCompiler.getPartialDerivativeIndex(n3, n4, nArray2, nArray3);
    }

    public int[] getPartialDerivativeOrders(int n) {
        return this.derivativesIndirection[n];
    }

    public int getFreeParameters() {
        return this.parameters;
    }

    public int getOrder() {
        return this.order;
    }

    public int getSize() {
        return this.sizes[this.parameters][this.order];
    }

    public void linearCombination(double d2, double[] dArray, int n, double d3, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            dArray3[n3 + i2] = MathArrays.linearCombination(d2, dArray[n + i2], d3, dArray2[n2 + i2]);
        }
    }

    public void linearCombination(double d2, double[] dArray, int n, double d3, double[] dArray2, int n2, double d4, double[] dArray3, int n3, double[] dArray4, int n4) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            dArray4[n4 + i2] = MathArrays.linearCombination(d2, dArray[n + i2], d3, dArray2[n2 + i2], d4, dArray3[n3 + i2]);
        }
    }

    public void linearCombination(double d2, double[] dArray, int n, double d3, double[] dArray2, int n2, double d4, double[] dArray3, int n3, double d5, double[] dArray4, int n4, double[] dArray5, int n5) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            dArray5[n5 + i2] = MathArrays.linearCombination(d2, dArray[n + i2], d3, dArray2[n2 + i2], d4, dArray3[n3 + i2], d5, dArray4[n4 + i2]);
        }
    }

    public void add(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            dArray3[n3 + i2] = dArray[n + i2] + dArray2[n2 + i2];
        }
    }

    public void subtract(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            dArray3[n3 + i2] = dArray[n + i2] - dArray2[n2 + i2];
        }
    }

    public void multiply(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        for (int i2 = 0; i2 < this.multIndirection.length; ++i2) {
            int[][] nArray = this.multIndirection[i2];
            double d2 = 0.0;
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                d2 += (double)nArray[i3][0] * dArray[n + nArray[i3][1]] * dArray2[n2 + nArray[i3][2]];
            }
            dArray3[n3 + i2] = d2;
        }
    }

    public void divide(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double[] dArray4 = new double[this.getSize()];
        this.pow(dArray2, n, -1, dArray4, 0);
        this.multiply(dArray, n, dArray4, 0, dArray3, n3);
    }

    public void remainder(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double d2 = FastMath.IEEEremainder(dArray[n], dArray2[n2]);
        double d3 = FastMath.rint((dArray[n] - d2) / dArray2[n2]);
        dArray3[n3] = d2;
        for (int i2 = 1; i2 < this.getSize(); ++i2) {
            dArray3[n3 + i2] = dArray[n + i2] - d3 * dArray2[n2 + i2];
        }
    }

    public void pow(double d2, double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        if (d2 == 0.0) {
            if (dArray[n] == 0.0) {
                dArray3[0] = 1.0;
                double d3 = Double.POSITIVE_INFINITY;
                for (int i2 = 1; i2 < dArray3.length; ++i2) {
                    dArray3[i2] = d3 = -d3;
                }
            } else if (dArray[n] < 0.0) {
                Arrays.fill(dArray3, Double.NaN);
            }
        } else {
            dArray3[0] = FastMath.pow(d2, dArray[n]);
            double d4 = FastMath.log(d2);
            for (int i3 = 1; i3 < dArray3.length; ++i3) {
                dArray3[i3] = d4 * dArray3[i3 - 1];
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void pow(double[] dArray, int n, double d2, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d3 = FastMath.pow(dArray[n], d2 - (double)this.order);
        for (int i2 = this.order; i2 > 0; --i2) {
            dArray3[i2] = d3;
            d3 *= dArray[n];
        }
        dArray3[0] = d3;
        double d4 = d2;
        for (int i3 = 1; i3 <= this.order; ++i3) {
            int n3 = i3;
            dArray3[n3] = dArray3[n3] * d4;
            d4 *= d2 - (double)i3;
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void pow(double[] dArray, int n, int n2, double[] dArray2, int n3) {
        if (n2 == 0) {
            dArray2[n3] = 1.0;
            Arrays.fill(dArray2, n3 + 1, n3 + this.getSize(), 0.0);
            return;
        }
        double[] dArray3 = new double[1 + this.order];
        if (n2 > 0) {
            int n4 = FastMath.min(this.order, n2);
            double d2 = FastMath.pow(dArray[n], n2 - n4);
            for (int i2 = n4; i2 > 0; --i2) {
                dArray3[i2] = d2;
                d2 *= dArray[n];
            }
            dArray3[0] = d2;
        } else {
            double d3 = 1.0 / dArray[n];
            double d4 = FastMath.pow(d3, -n2);
            for (int i3 = 0; i3 <= this.order; ++i3) {
                dArray3[i3] = d4;
                d4 *= d3;
            }
        }
        double d5 = n2;
        for (int i4 = 1; i4 <= this.order; ++i4) {
            int n5 = i4;
            dArray3[n5] = dArray3[n5] * d5;
            d5 *= (double)(n2 - i4);
        }
        this.compose(dArray, n, dArray3, dArray2, n3);
    }

    public void pow(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double[] dArray4 = new double[this.getSize()];
        this.log(dArray, n, dArray4, 0);
        dArray = new double[this.getSize()];
        this.multiply(dArray4, 0, dArray2, n2, dArray, 0);
        this.exp(dArray, 0, dArray3, n3);
    }

    public void rootN(double[] dArray, int n, int n2, double[] dArray2, int n3) {
        double d2;
        double[] dArray3 = new double[1 + this.order];
        if (n2 == 2) {
            dArray3[0] = FastMath.sqrt(dArray[n]);
            d2 = 0.5 / dArray3[0];
        } else if (n2 == 3) {
            dArray3[0] = FastMath.cbrt(dArray[n]);
            d2 = 1.0 / (3.0 * dArray3[0] * dArray3[0]);
        } else {
            dArray3[0] = FastMath.pow(dArray[n], 1.0 / (double)n2);
            d2 = 1.0 / ((double)n2 * FastMath.pow(dArray3[0], n2 - 1));
        }
        double d3 = 1.0 / (double)n2;
        double d4 = 1.0 / dArray[n];
        for (n2 = 1; n2 <= this.order; ++n2) {
            dArray3[n2] = d2;
            d2 *= d4 * (d3 - (double)n2);
        }
        this.compose(dArray, n, dArray3, dArray2, n3);
    }

    public void exp(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        Arrays.fill(dArray3, FastMath.exp(dArray[n]));
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void expm1(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.expm1(dArray[n]);
        Arrays.fill(dArray4, 1, 1 + this.order, FastMath.exp(dArray[n]));
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void log(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.log(dArray[n]);
        if (this.order > 0) {
            double d2;
            double d3 = d2 = 1.0 / dArray[n];
            for (int i2 = 1; i2 <= this.order; ++i2) {
                dArray4[i2] = d3;
                d3 *= (double)(-i2) * d2;
            }
        }
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void log1p(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.log1p(dArray[n]);
        if (this.order > 0) {
            double d2;
            double d3 = d2 = 1.0 / (1.0 + dArray[n]);
            for (int i2 = 1; i2 <= this.order; ++i2) {
                dArray4[i2] = d3;
                d3 *= (double)(-i2) * d2;
            }
        }
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void log10(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.log10(dArray[n]);
        if (this.order > 0) {
            double d2 = 1.0 / dArray[n];
            double d3 = d2 / FastMath.log(10.0);
            for (int i2 = 1; i2 <= this.order; ++i2) {
                dArray4[i2] = d3;
                d3 *= (double)(-i2) * d2;
            }
        }
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void cos(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.cos(dArray[n]);
        if (this.order > 0) {
            dArray4[1] = -FastMath.sin(dArray[n]);
            for (int i2 = 2; i2 <= this.order; ++i2) {
                dArray4[i2] = -dArray4[i2 - 2];
            }
        }
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void sin(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.sin(dArray[n]);
        if (this.order > 0) {
            dArray4[1] = FastMath.cos(dArray[n]);
            for (int i2 = 2; i2 <= this.order; ++i2) {
                dArray4[i2] = -dArray4[i2 - 2];
            }
        }
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void tan(double[] dArray, int n, double[] dArray2, int n2) {
        double d2;
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = d2 = FastMath.tan(dArray[n]);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order + 2];
            double[] dArray5 = dArray4;
            dArray4[1] = 1.0;
            double d3 = d2;
            double d4 = d3 * d3;
            for (int i2 = 1; i2 <= this.order; ++i2) {
                double d5 = 0.0;
                dArray5[i2 + 1] = (double)i2 * dArray5[i2];
                for (int i3 = i2 + 1; i3 >= 0; i3 -= 2) {
                    d5 = d5 * d4 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(i3 - 1) * dArray5[i3 - 1] + (double)(i3 - 3) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d5 *= d2;
                }
                dArray3[i2] = d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void acos(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d2 = dArray[n];
        dArray3[0] = FastMath.acos(d2);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            double[] dArray5 = dArray4;
            dArray4[0] = -1.0;
            double d3 = d2;
            double d4 = d3 * d3;
            double d5 = 1.0 / (1.0 - d4);
            double d6 = FastMath.sqrt(d5);
            dArray3[1] = d6 * dArray5[0];
            for (int i2 = 2; i2 <= this.order; ++i2) {
                double d7 = 0.0;
                dArray5[i2 - 1] = (double)(i2 - 1) * dArray5[i2 - 2];
                for (int i3 = i2 - 1; i3 >= 0; i3 -= 2) {
                    d7 = d7 * d4 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(i3 - 1) * dArray5[i3 - 1] + (double)(2 * i2 - i3) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d7 *= d2;
                }
                dArray3[i2] = (d6 *= d5) * d7;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void asin(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d2 = dArray[n];
        dArray3[0] = FastMath.asin(d2);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            double[] dArray5 = dArray4;
            dArray4[0] = 1.0;
            double d3 = d2;
            double d4 = d3 * d3;
            double d5 = 1.0 / (1.0 - d4);
            double d6 = FastMath.sqrt(d5);
            dArray3[1] = d6 * dArray5[0];
            for (int i2 = 2; i2 <= this.order; ++i2) {
                double d7 = 0.0;
                dArray5[i2 - 1] = (double)(i2 - 1) * dArray5[i2 - 2];
                for (int i3 = i2 - 1; i3 >= 0; i3 -= 2) {
                    d7 = d7 * d4 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(i3 - 1) * dArray5[i3 - 1] + (double)(2 * i2 - i3) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d7 *= d2;
                }
                dArray3[i2] = (d6 *= d5) * d7;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void atan(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d2 = dArray[n];
        dArray3[0] = FastMath.atan(d2);
        if (this.order > 0) {
            double d3;
            double[] dArray4 = new double[this.order];
            double[] dArray5 = dArray4;
            dArray4[0] = 1.0;
            double d4 = d2;
            double d5 = d4 * d4;
            double d6 = d3 = 1.0 / (d5 + 1.0);
            dArray3[1] = d6 * dArray5[0];
            for (int i2 = 2; i2 <= this.order; ++i2) {
                double d7 = 0.0;
                dArray5[i2 - 1] = (double)(-i2) * dArray5[i2 - 2];
                for (int i3 = i2 - 1; i3 >= 0; i3 -= 2) {
                    d7 = d7 * d5 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(i3 - 1) * dArray5[i3 - 1] + (double)(i3 - 1 - 2 * i2) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d7 *= d2;
                }
                dArray3[i2] = (d6 *= d3) * d7;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void atan2(double[] dArray, int n, double[] dArray2, int n2, double[] dArray3, int n3) {
        double[] dArray4 = new double[this.getSize()];
        this.multiply(dArray2, n2, dArray2, n2, dArray4, 0);
        double[] dArray5 = new double[this.getSize()];
        this.multiply(dArray, n, dArray, n, dArray5, 0);
        this.add(dArray4, 0, dArray5, 0, dArray5, 0);
        this.rootN(dArray5, 0, 2, dArray4, 0);
        if (dArray2[n2] >= 0.0) {
            this.add(dArray4, 0, dArray2, n2, dArray5, 0);
            this.divide(dArray, n, dArray5, 0, dArray4, 0);
            this.atan(dArray4, 0, dArray5, 0);
            for (int i2 = 0; i2 < dArray5.length; ++i2) {
                dArray3[n3 + i2] = 2.0 * dArray5[i2];
            }
        } else {
            this.subtract(dArray4, 0, dArray2, n2, dArray5, 0);
            this.divide(dArray, n, dArray5, 0, dArray4, 0);
            this.atan(dArray4, 0, dArray5, 0);
            dArray3[n3] = (dArray5[0] <= 0.0 ? -Math.PI : Math.PI) - 2.0 * dArray5[0];
            for (int i3 = 1; i3 < dArray5.length; ++i3) {
                dArray3[n3 + i3] = -2.0 * dArray5[i3];
            }
        }
        dArray3[n3] = FastMath.atan2(dArray[n], dArray2[n2]);
    }

    public void cosh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.cosh(dArray[n]);
        if (this.order > 0) {
            dArray4[1] = FastMath.sinh(dArray[n]);
            for (int i2 = 2; i2 <= this.order; ++i2) {
                dArray4[i2] = dArray4[i2 - 2];
            }
        }
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void sinh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double[] dArray4 = dArray3;
        dArray3[0] = FastMath.sinh(dArray[n]);
        if (this.order > 0) {
            dArray4[1] = FastMath.cosh(dArray[n]);
            for (int i2 = 2; i2 <= this.order; ++i2) {
                dArray4[i2] = dArray4[i2 - 2];
            }
        }
        this.compose(dArray, n, dArray4, dArray2, n2);
    }

    public void tanh(double[] dArray, int n, double[] dArray2, int n2) {
        double d2;
        double[] dArray3 = new double[1 + this.order];
        dArray3[0] = d2 = FastMath.tanh(dArray[n]);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order + 2];
            double[] dArray5 = dArray4;
            dArray4[1] = 1.0;
            double d3 = d2;
            double d4 = d3 * d3;
            for (int i2 = 1; i2 <= this.order; ++i2) {
                double d5 = 0.0;
                dArray5[i2 + 1] = (double)(-i2) * dArray5[i2];
                for (int i3 = i2 + 1; i3 >= 0; i3 -= 2) {
                    d5 = d5 * d4 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(i3 - 1) * dArray5[i3 - 1] - (double)(i3 - 3) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d5 *= d2;
                }
                dArray3[i2] = d5;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void acosh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d2 = dArray[n];
        dArray3[0] = FastMath.acosh(d2);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            double[] dArray5 = dArray4;
            dArray4[0] = 1.0;
            double d3 = d2;
            double d4 = d3 * d3;
            double d5 = 1.0 / (d4 - 1.0);
            double d6 = FastMath.sqrt(d5);
            dArray3[1] = d6 * dArray5[0];
            for (int i2 = 2; i2 <= this.order; ++i2) {
                double d7 = 0.0;
                dArray5[i2 - 1] = (double)(1 - i2) * dArray5[i2 - 2];
                for (int i3 = i2 - 1; i3 >= 0; i3 -= 2) {
                    d7 = d7 * d4 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(1 - i3) * dArray5[i3 - 1] + (double)(i3 - 2 * i2) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = -dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d7 *= d2;
                }
                dArray3[i2] = (d6 *= d5) * d7;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void asinh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d2 = dArray[n];
        dArray3[0] = FastMath.asinh(d2);
        if (this.order > 0) {
            double[] dArray4 = new double[this.order];
            double[] dArray5 = dArray4;
            dArray4[0] = 1.0;
            double d3 = d2;
            double d4 = d3 * d3;
            double d5 = 1.0 / (d4 + 1.0);
            double d6 = FastMath.sqrt(d5);
            dArray3[1] = d6 * dArray5[0];
            for (int i2 = 2; i2 <= this.order; ++i2) {
                double d7 = 0.0;
                dArray5[i2 - 1] = (double)(1 - i2) * dArray5[i2 - 2];
                for (int i3 = i2 - 1; i3 >= 0; i3 -= 2) {
                    d7 = d7 * d4 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(i3 - 1) * dArray5[i3 - 1] + (double)(i3 - 2 * i2) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d7 *= d2;
                }
                dArray3[i2] = (d6 *= d5) * d7;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void atanh(double[] dArray, int n, double[] dArray2, int n2) {
        double[] dArray3 = new double[1 + this.order];
        double d2 = dArray[n];
        dArray3[0] = FastMath.atanh(d2);
        if (this.order > 0) {
            double d3;
            double[] dArray4 = new double[this.order];
            double[] dArray5 = dArray4;
            dArray4[0] = 1.0;
            double d4 = d2;
            double d5 = d4 * d4;
            double d6 = d3 = 1.0 / (1.0 - d5);
            dArray3[1] = d6 * dArray5[0];
            for (int i2 = 2; i2 <= this.order; ++i2) {
                double d7 = 0.0;
                dArray5[i2 - 1] = (double)i2 * dArray5[i2 - 2];
                for (int i3 = i2 - 1; i3 >= 0; i3 -= 2) {
                    d7 = d7 * d5 + dArray5[i3];
                    if (i3 > 2) {
                        dArray5[i3 - 2] = (double)(i3 - 1) * dArray5[i3 - 1] + (double)(2 * i2 - i3 + 1) * dArray5[i3 - 3];
                        continue;
                    }
                    if (i3 != 2) continue;
                    dArray5[0] = dArray5[1];
                }
                if ((i2 & 1) == 0) {
                    d7 *= d2;
                }
                dArray3[i2] = (d6 *= d3) * d7;
            }
        }
        this.compose(dArray, n, dArray3, dArray2, n2);
    }

    public void compose(double[] dArray, int n, double[] dArray2, double[] dArray3, int n2) {
        for (int i2 = 0; i2 < this.compIndirection.length; ++i2) {
            int[][] nArray = this.compIndirection[i2];
            double d2 = 0.0;
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int[] nArray2 = nArray[i3];
                double d3 = (double)nArray2[0] * dArray2[nArray2[1]];
                for (int i4 = 2; i4 < nArray2.length; ++i4) {
                    d3 *= dArray[n + nArray2[i4]];
                }
                d2 += d3;
            }
            dArray3[n2 + i2] = d2;
        }
    }

    public double taylor(double[] dArray, int n, double ... dArray2) {
        double d2 = 0.0;
        for (int i2 = this.getSize() - 1; i2 >= 0; --i2) {
            int[] nArray = this.getPartialDerivativeOrders(i2);
            double d3 = dArray[n + i2];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                if (nArray[i3] <= 0) continue;
                try {
                    d3 *= FastMath.pow(dArray2[i3], nArray[i3]) / (double)CombinatoricsUtils.factorial(nArray[i3]);
                    continue;
                }
                catch (NotPositiveException notPositiveException) {
                    throw new MathInternalError(notPositiveException);
                }
            }
            d2 += d3;
        }
        return d2;
    }

    public void checkCompatibility(DSCompiler dSCompiler) {
        if (this.parameters != dSCompiler.parameters) {
            throw new DimensionMismatchException(this.parameters, dSCompiler.parameters);
        }
        if (this.order != dSCompiler.order) {
            throw new DimensionMismatchException(this.order, dSCompiler.order);
        }
    }
}

