/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis;

import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.BivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableMultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$1;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$10;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$11;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$12;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$13;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$14;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$15;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$16;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$17;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$18;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$19;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$2;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$3;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$4;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$5;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$6;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$7;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$8;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.FunctionUtils$9;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.MultivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.UnivariateFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.differentiation.UnivariateDifferentiableFunction;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.analysis.function.Identity;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NotStrictlyPositiveException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.NumberIsTooLargeException;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.Localizable;
import games.aquastudios.aquaclient.shaded.apache.commons.math3.exception.util.LocalizedFormats;

public class FunctionUtils {
    private FunctionUtils() {
    }

    public static UnivariateFunction compose(UnivariateFunction ... univariateFunctionArray) {
        return new FunctionUtils$1(univariateFunctionArray);
    }

    public static UnivariateDifferentiableFunction compose(UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new FunctionUtils$2(univariateDifferentiableFunctionArray);
    }

    @Deprecated
    public static DifferentiableUnivariateFunction compose(DifferentiableUnivariateFunction ... differentiableUnivariateFunctionArray) {
        return new FunctionUtils$3(differentiableUnivariateFunctionArray);
    }

    public static UnivariateFunction add(UnivariateFunction ... univariateFunctionArray) {
        return new FunctionUtils$4(univariateFunctionArray);
    }

    public static UnivariateDifferentiableFunction add(UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new FunctionUtils$5(univariateDifferentiableFunctionArray);
    }

    @Deprecated
    public static DifferentiableUnivariateFunction add(DifferentiableUnivariateFunction ... differentiableUnivariateFunctionArray) {
        return new FunctionUtils$6(differentiableUnivariateFunctionArray);
    }

    public static UnivariateFunction multiply(UnivariateFunction ... univariateFunctionArray) {
        return new FunctionUtils$7(univariateFunctionArray);
    }

    public static UnivariateDifferentiableFunction multiply(UnivariateDifferentiableFunction ... univariateDifferentiableFunctionArray) {
        return new FunctionUtils$8(univariateDifferentiableFunctionArray);
    }

    @Deprecated
    public static DifferentiableUnivariateFunction multiply(DifferentiableUnivariateFunction ... differentiableUnivariateFunctionArray) {
        return new FunctionUtils$9(differentiableUnivariateFunctionArray);
    }

    public static UnivariateFunction combine(BivariateFunction bivariateFunction, UnivariateFunction univariateFunction, UnivariateFunction univariateFunction2) {
        return new FunctionUtils$10(bivariateFunction, univariateFunction, univariateFunction2);
    }

    public static MultivariateFunction collector(BivariateFunction bivariateFunction, UnivariateFunction univariateFunction, double d2) {
        return new FunctionUtils$11(bivariateFunction, d2, univariateFunction);
    }

    public static MultivariateFunction collector(BivariateFunction bivariateFunction, double d2) {
        return FunctionUtils.collector(bivariateFunction, new Identity(), d2);
    }

    public static UnivariateFunction fix1stArgument(BivariateFunction bivariateFunction, double d2) {
        return new FunctionUtils$12(bivariateFunction, d2);
    }

    public static UnivariateFunction fix2ndArgument(BivariateFunction bivariateFunction, double d2) {
        return new FunctionUtils$13(bivariateFunction, d2);
    }

    public static double[] sample(UnivariateFunction univariateFunction, double d2, double d3, int n) {
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NOT_POSITIVE_NUMBER_OF_SAMPLES, n);
        }
        if (d2 >= d3) {
            throw new NumberIsTooLargeException(d2, (Number)d3, false);
        }
        double[] dArray = new double[n];
        double d4 = (d3 - d2) / (double)n;
        for (int i2 = 0; i2 < n; ++i2) {
            dArray[i2] = univariateFunction.value(d2 + (double)i2 * d4);
        }
        return dArray;
    }

    @Deprecated
    public static DifferentiableUnivariateFunction toDifferentiableUnivariateFunction(UnivariateDifferentiableFunction univariateDifferentiableFunction) {
        return new FunctionUtils$14(univariateDifferentiableFunction);
    }

    @Deprecated
    public static UnivariateDifferentiableFunction toUnivariateDifferential(DifferentiableUnivariateFunction differentiableUnivariateFunction) {
        return new FunctionUtils$15(differentiableUnivariateFunction);
    }

    @Deprecated
    public static DifferentiableMultivariateFunction toDifferentiableMultivariateFunction(MultivariateDifferentiableFunction multivariateDifferentiableFunction) {
        return new FunctionUtils$16(multivariateDifferentiableFunction);
    }

    @Deprecated
    public static MultivariateDifferentiableFunction toMultivariateDifferentiableFunction(DifferentiableMultivariateFunction differentiableMultivariateFunction) {
        return new FunctionUtils$17(differentiableMultivariateFunction);
    }

    @Deprecated
    public static DifferentiableMultivariateVectorFunction toDifferentiableMultivariateVectorFunction(MultivariateDifferentiableVectorFunction multivariateDifferentiableVectorFunction) {
        return new FunctionUtils$18(multivariateDifferentiableVectorFunction);
    }

    @Deprecated
    public static MultivariateDifferentiableVectorFunction toMultivariateDifferentiableVectorFunction(DifferentiableMultivariateVectorFunction differentiableMultivariateVectorFunction) {
        return new FunctionUtils$19(differentiableMultivariateVectorFunction);
    }
}

