/*
 * Decompiled with CFR 0.152.
 */
package games.aquastudios.aquaclient;

import games.aquastudios.aquaclient.AquaClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public final class AquaClientConfig {
    private static File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "aquaclient.properties");
    public static boolean darkMode = true;
    public static boolean discordRPC = true;
    public static boolean cosmetics = true;
    public static boolean extendChatHistory = true;
    public static boolean disableRamWarning = false;
    public static boolean optimizeMath = true;
    public static boolean optimizeParticles = true;
    public static boolean disableDebugRenderer = true;
    public static boolean disableTutorial = true;
    public static boolean fullbright = false;
    public static boolean disablePumpkinOverlay = false;
    public static boolean disablePortalOverlay = false;
    public static boolean disableRecipeToasts = false;
    public static boolean showNumericPing = false;
    public static boolean cleanF3 = true;
    public static int fireOffset = 0;
    public static int shieldOffset = 0;

    public static void init() {
        Properties properties = new Properties();
        try {
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.createNewFile();
            }
            try (Field[] fieldArray = new FileInputStream(CONFIG_FILE);){
                properties.load((InputStream)fieldArray);
            }
            catch (Exception exception) {
                AquaClient.a.error("Failed to load Aqua Client configuration: ", exception);
            }
        }
        catch (Exception exception) {
            AquaClient.a.error("Failed to load Aqua Client configuration file: ", exception);
        }
        for (Field field : AquaClientConfig.class.getDeclaredFields()) {
            if (!properties.containsKey(field.getName()) || field.getName().equals("CONFIG_FILE")) continue;
            try {
                if (field.getType() == Boolean.TYPE) {
                    field.set(null, Boolean.parseBoolean(properties.getProperty(field.getName(), field.get(null).toString())));
                    continue;
                }
                if (field.getType() != Integer.TYPE) continue;
                field.set(null, Integer.parseInt(properties.getProperty(field.getName(), field.get(null).toString())));
            }
            catch (Exception exception) {
                AquaClient.a.error("Failed to set property {} in Aqua Client configuration: ", (Object)field.getName(), (Object)exception);
            }
        }
        AquaClientConfig.save();
    }

    public static void save() {
        Properties properties = new Properties();
        for (Field field : AquaClientConfig.class.getDeclaredFields()) {
            if (field.getName().equals("CONFIG_FILE")) continue;
            try {
                properties.setProperty(field.getName(), field.get(null).toString());
            }
            catch (Exception exception) {
                AquaClient.a.error("Failed to save property {} in Aqua Client configuration: ", (Object)field.getName(), (Object)exception);
            }
        }
        try {
            if (!CONFIG_FILE.getParentFile().exists()) {
                CONFIG_FILE.getParentFile().mkdirs();
            }
            if (!CONFIG_FILE.exists()) {
                CONFIG_FILE.createNewFile();
            }
            try (FileOutputStream fileOutputStream = new FileOutputStream(CONFIG_FILE);){
                properties.store(fileOutputStream, "Aqua Client v" + AquaClient.c + " Configuration");
            }
            catch (Exception exception) {
                AquaClient.a.error("Failed to save Aqua Client configuration: ", exception);
            }
            return;
        }
        catch (Exception exception) {
            AquaClient.a.error("Failed to create Aqua Client configuration file: ", exception);
            return;
        }
    }
}

