/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.api.internal;

import java.lang.reflect.Constructor;

public class DependencyInjection {
    public static <T> T load(Class<T> apiClass, String implClassName) {
        Object implInstance;
        Constructor<?> implConstructor;
        Class<?> implClass;
        try {
            implClass = Class.forName(implClassName);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not find implementation", e);
        }
        if (!apiClass.isAssignableFrom(implClass)) {
            throw new RuntimeException("Class %s does not implement interface %s".formatted(implClass.getName(), apiClass.getName()));
        }
        try {
            implConstructor = implClass.getConstructor(new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not find default constructor", e);
        }
        try {
            implInstance = implConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not instantiate implementation", e);
        }
        return apiClass.cast(implInstance);
    }
}

