/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.RecordingTooltipSupplier;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Objects;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_124;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class VoiceChatScreen
extends VoiceChatScreenBase {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"voicechat", (String)"textures/gui/gui_voicechat.png");
    private static final class_2960 MICROPHONE = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone_button.png");
    private static final class_2960 HIDE = class_2960.method_60655((String)"voicechat", (String)"textures/icons/hide_button.png");
    private static final class_2960 VOLUMES = class_2960.method_60655((String)"voicechat", (String)"textures/icons/adjust_volumes.png");
    private static final class_2960 SPEAKER = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker_button.png");
    private static final class_2960 RECORD = class_2960.method_60655((String)"voicechat", (String)"textures/icons/record_button.png");
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.voicechat.voice_chat.title");
    private static final class_2561 SETTINGS = class_2561.method_43471((String)"message.voicechat.settings");
    private static final class_2561 GROUP = class_2561.method_43471((String)"message.voicechat.group");
    public static final class_2561 ADJUST_PLAYER_VOLUMES = class_2561.method_43471((String)"message.voicechat.adjust_volumes");
    private ToggleImageButton mute;
    private ToggleImageButton disable;
    private VoiceChatScreenBase.HoverArea recordingHoverArea;
    private ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();

    public VoiceChatScreen() {
        super(TITLE, 195, 76);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        ClientVoicechat client = ClientManager.getClient();
        this.mute = new ToggleImageButton(this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, MICROPHONE, this.stateManager::isMuted, button -> this.stateManager.setMuted(!this.stateManager.isMuted()), new MuteTooltipSupplier(this, this.stateManager));
        this.method_37063((class_364)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 6 + 20 + 2, this.guiTop + this.ySize - 6 - 20, SPEAKER, this.stateManager::isDisabled, button -> this.stateManager.setDisabled(!this.stateManager.isDisabled()), new DisableTooltipSupplier(this, this.stateManager));
        this.method_37063((class_364)this.disable);
        ImageButton volumes = new ImageButton(this.guiLeft + 6 + 20 + 2 + 20 + 2, this.guiTop + this.ySize - 6 - 20, VOLUMES, button -> this.field_22787.method_1507((class_437)new AdjustVolumesScreen()), (button, guiGraphics, font, mouseX, mouseY) -> guiGraphics.method_51438(font, ADJUST_PLAYER_VOLUMES, mouseX, mouseY));
        this.method_37063((class_364)volumes);
        if (client != null && VoicechatClient.CLIENT_CONFIG.useNatives.get().booleanValue() && (client.getRecorder() != null || client.getConnection() != null && client.getConnection().getData().allowRecording())) {
            ToggleImageButton record = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, RECORD, () -> ClientManager.getClient() != null && ClientManager.getClient().getRecorder() != null, button -> this.toggleRecording(), new RecordingTooltipSupplier(this));
            this.method_37063((class_364)record);
        }
        ToggleImageButton hide = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE, VoicechatClient.CLIENT_CONFIG.hideIcons::get, button -> VoicechatClient.CLIENT_CONFIG.hideIcons.set(VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false).save(), new HideTooltipSupplier(this));
        this.method_37063((class_364)hide);
        class_4185 settings = class_4185.method_46430((class_2561)SETTINGS, button -> this.field_22787.method_1507((class_437)new VoiceChatSettingsScreen())).method_46434(this.guiLeft + 6, this.guiTop + 6 + 15, 75, 20).method_46431();
        this.method_37063((class_364)settings);
        class_4185 group = class_4185.method_46430((class_2561)GROUP, button -> {
            ClientGroup g = this.stateManager.getGroup();
            if (g != null) {
                this.field_22787.method_1507((class_437)new GroupScreen(g));
            } else {
                this.field_22787.method_1507((class_437)new JoinGroupScreen());
            }
        }).method_46434(this.guiLeft + this.xSize - 6 - 75 + 1, this.guiTop + 6 + 15, 75, 20).method_46431();
        this.method_37063((class_364)group);
        group.field_22763 = client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled();
        this.recordingHoverArea = new VoiceChatScreenBase.HoverArea(72, this.ySize - 6 - 20, this.xSize - 122, 20);
        this.checkButtons();
    }

    public void method_25393() {
        super.method_25393();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.field_22763 = MuteTooltipSupplier.canMuteMic();
        this.disable.field_22763 = this.stateManager.canEnable();
    }

    private void toggleRecording() {
        ClientVoicechat c = ClientManager.getClient();
        if (c == null) {
            return;
        }
        c.toggleRecording();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).method_1444()) {
            this.field_22787.method_1507(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25290(class_1921::method_62277, TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
    }

    @Override
    public void renderForeground(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        int titleWidth = this.field_22793.method_27525((class_5348)TITLE);
        guiGraphics.method_51430(this.field_22793, TITLE.method_30937(), this.guiLeft + (this.xSize - titleWidth) / 2, this.guiTop + 7, 0x404040, false);
        ClientVoicechat client = ClientManager.getClient();
        if (client != null && client.getRecorder() != null) {
            AudioRecorder recorder = client.getRecorder();
            class_5250 time = class_2561.method_43470((String)recorder.getDuration());
            class_5250 class_52502 = time.method_27692(class_124.field_1079);
            int n = this.guiLeft + this.recordingHoverArea.getPosX() + this.recordingHoverArea.getWidth() / 2 - this.field_22793.method_27525((class_5348)time) / 2;
            int n2 = this.guiTop + this.recordingHoverArea.getPosY() + this.recordingHoverArea.getHeight() / 2;
            Objects.requireNonNull(this.field_22793);
            guiGraphics.method_51439(this.field_22793, (class_2561)class_52502, n, n2 - 9 / 2, 0, false);
            if (this.recordingHoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                guiGraphics.method_51438(this.field_22793, (class_2561)class_2561.method_43469((String)"message.voicechat.storage_size", (Object[])new Object[]{recorder.getStorage()}), mouseX, mouseY);
            }
        }
    }
}

