/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam.behaviour;

import com.shmove.cat_jam.access.JammingEntity;
import com.shmove.cat_jam.cat_jam;
import com.shmove.cat_jam.discs.DiscPlayback;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;

public class JammingState {
    private final class_1309 jammingEntity;
    private class_2338 musicSourceBlock = null;
    private Integer musicSourceEntityID = null;
    private boolean catJamming = false;
    private DiscPlayback discPlayback = null;
    private int nodTick = -1;
    private int slightNodTick = -1;

    public JammingState(class_1309 jammingEntity) {
        this.jammingEntity = jammingEntity;
    }

    public void tick() {
        class_1297 musicSourceEntity;
        if (!this.jammingEntity.method_37908().field_9236) {
            return;
        }
        if (!(this.musicSourceBlock == null || this.musicSourceBlock.method_19769((class_2374)this.jammingEntity.method_19538(), 3.46) && cat_jam.isSourcePlayingAtPos(this.musicSourceBlock))) {
            this.resetJammingInfo();
        }
        if (!(this.musicSourceEntityID == null || (musicSourceEntity = this.jammingEntity.method_37908().method_8469(this.musicSourceEntityID.intValue())) != null && musicSourceEntity.method_24516((class_1297)this.jammingEntity, 3.46) && musicSourceEntity.method_5805() && cat_jam.isSourcePlayingFromEntity(this.musicSourceEntityID))) {
            this.resetJammingInfo();
        }
        if (!this.catJamming) {
            this.findNewMusicSource();
        }
        if (this.catJamming) {
            this.updateNod();
            this.updateNodAnim();
        }
    }

    public void resetJammingInfo() {
        this.musicSourceBlock = null;
        this.musicSourceEntityID = null;
        this.discPlayback = null;
        this.catJamming = false;
        this.nodTick = -1;
        this.slightNodTick = -1;
    }

    public int getNodTick() {
        return this.nodTick;
    }

    public int getSlightNodTick() {
        return this.slightNodTick;
    }

    public void updateMusicSource(class_2338 sourcePos) {
        if (!((JammingEntity)this.jammingEntity).cat_jam$isInValidStateToJam()) {
            return;
        }
        this.musicSourceBlock = sourcePos;
        this.discPlayback = cat_jam.getDiscPlaybackAtPos(sourcePos);
        this.catJamming = true;
        this.jammingEntity.method_37908().method_8406((class_2394)class_2398.field_11224, this.jammingEntity.method_23317(), this.jammingEntity.method_23318() + 0.3, this.jammingEntity.method_23321(), 0.0, 0.0, 0.0);
    }

    public void updateMusicSource(Integer sourceEntityID) {
        if (!((JammingEntity)this.jammingEntity).cat_jam$isInValidStateToJam()) {
            return;
        }
        this.musicSourceEntityID = sourceEntityID;
        this.discPlayback = cat_jam.getDiscPlaybackFromEntity(sourceEntityID);
        this.catJamming = true;
        this.jammingEntity.method_37908().method_8406((class_2394)class_2398.field_11224, this.jammingEntity.method_23317(), this.jammingEntity.method_23318() + 0.3, this.jammingEntity.method_23321(), 0.0, 0.0, 0.0);
    }

    private void findNewMusicSource() {
        boolean FOUND_ENTITY_SOURCE;
        class_2338 nearbyBlockSource = cat_jam.getClosestListenableSourcePos(this.jammingEntity.method_19538());
        class_1297 nearbyEntitySource = cat_jam.getClosestListenableSourceEntity(this.jammingEntity.method_19538());
        boolean FOUND_BLOCK_SOURCE = nearbyBlockSource != null;
        boolean bl = FOUND_ENTITY_SOURCE = nearbyEntitySource != null;
        if (!FOUND_BLOCK_SOURCE && !FOUND_ENTITY_SOURCE) {
            return;
        }
        if (FOUND_BLOCK_SOURCE && FOUND_ENTITY_SOURCE) {
            double entityDist;
            double blockDist = nearbyBlockSource.method_19770((class_2374)this.jammingEntity.method_19538());
            if (blockDist < (entityDist = nearbyEntitySource.method_5858((class_1297)this.jammingEntity))) {
                this.updateMusicSource(nearbyBlockSource);
            } else {
                this.updateMusicSource(nearbyEntitySource.method_5628());
            }
        } else if (FOUND_BLOCK_SOURCE) {
            this.updateMusicSource(nearbyBlockSource);
        } else if (FOUND_ENTITY_SOURCE) {
            this.updateMusicSource(nearbyEntitySource.method_5628());
        }
    }

    private void updateNod() {
        int nodPreempt = 2;
        boolean slightNodPreempt = true;
        if (this.discPlayback.anticipateBeat(2) && this.discPlayback.isNodBeat()) {
            if (this.nodTick >= 0 && this.nodTick <= 2) {
                return;
            }
            this.nodTick = 0;
        } else if (this.discPlayback.anticipateBeat(1) && this.discPlayback.isSlightNodBeat()) {
            if (this.slightNodTick >= 0 && this.slightNodTick <= 1) {
                return;
            }
            this.slightNodTick = 0;
        }
    }

    private void updateNodAnim() {
        int nodAnimTickLength = 8;
        int slightNodAnimTickLength = 6;
        if (this.nodTick >= 0) {
            if (this.nodTick < 7) {
                ++this.nodTick;
            } else if (this.nodTick == 7) {
                this.nodTick = -1;
            }
        }
        if (this.slightNodTick >= 0) {
            if (this.slightNodTick < 5) {
                ++this.slightNodTick;
            } else if (this.slightNodTick == 5) {
                this.slightNodTick = -1;
            }
        }
    }
}

